/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.plan;

import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.RebuildActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.RebuildType;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import java.util.Date;

public class PlanDumper {
    private ShopConfiguration configuration;
    private Plan plan;

    public PlanDumper(Plan plan) {
        this.plan = plan;
        this.configuration = plan.getShopConf();
    }

    private PlanDumper() {
        this.plan = null;
        this.configuration = null;
    }

    private void appendProperty(StringBuilder buf, String name, long value, int valPad) {
        this.appendProperty(buf, name, Long.toString(value), valPad);
    }

    private void appendProperty(StringBuilder buf, String name, double value, int valPad) {
        this.appendProperty(buf, name, Double.toString(value), valPad);
    }

    private void appendProperty(StringBuilder buf, String name, String value, int valPad) {
        buf.append(' ');
        buf.append(name);
        buf.append('=');
        if (value == null) {
            value = "(null)";
        }
        int pad = Math.max(0, valPad - value.length());
        while (pad-- > 0) {
            buf.append(' ');
        }
        buf.append(value);
    }

    private void appendCommonActivityProps(StringBuilder buf, WorkplaceActivity wpa) {
        if (Activity.convertDatesInToString) {
            this.appendProperty(buf, "start", new Date(wpa.getStart()).toString(), 30);
            this.appendProperty(buf, "end", new Date(wpa.getEnd()).toString(), 30);
        } else {
            this.appendProperty(buf, "start", wpa.getStart(), 10);
            this.appendProperty(buf, "end", wpa.getEnd(), 10);
        }
    }

    public String dumpWorkplaceSchedule(WorkplaceSchedule wps) {
        StringBuilder res = new StringBuilder();
        Workplace wp = wps.getWorkplace();
        res.append("Workplace ");
        res.append(wp.getName());
        res.append('\n');
        for (WorkplaceActivity wpa : wps.activities()) {
            if (wpa instanceof RebuildActivity) {
                RebuildActivity reb = (RebuildActivity)wpa;
                res.append("Rebuild");
                this.appendCommonActivityProps(res, wpa);
                this.appendProperty(res, "to", reb.getTo(), 10);
            } else if (wpa instanceof ActionActivity) {
                ActionActivity aa = (ActionActivity)wpa;
                res.append("Action ");
                this.appendCommonActivityProps(res, wpa);
                this.appendProperty(res, "prod", aa.getAction().getProduct().getName(), 10);
                this.appendProperty(res, "actn", aa.getAction().getName(), 10);
                this.appendProperty(res, "q", aa.getQty(), 6);
                GeneralizedOrderRequest gor = aa.getNearestGor();
                if (gor != null) {
                    this.appendProperty(res, "or", gor.getId(), 10);
                }
            } else if (wpa instanceof OfflineActivity) {
                res.append("Offline");
                this.appendCommonActivityProps(res, wpa);
            } else if (wpa instanceof CumulativeWorkplaceActivity) {
                res.append("CWA");
                this.appendCommonActivityProps(res, wpa);
                this.appendProperty(res, "fill", ((CumulativeWorkplaceActivity)wpa).getConsumption(), 6);
                for (ActionActivity aa : ((CumulativeWorkplaceActivity)wpa).getActionActivities()) {
                    CumulativeAction ca = (CumulativeAction)aa.getAction();
                    res.append("\n\t Action ");
                    this.appendCommonActivityProps(res, aa);
                    Product prod = ca.getProduct();
                    if (prod != null) {
                        this.appendProperty(res, "prod", prod.getName(), 10);
                    }
                    this.appendProperty(res, "actn", aa.getAction().getName(), 10);
                    this.appendProperty(res, "type", ca.getRebuildType(), 10);
                    this.appendProperty(res, "cumType", ca.getCumulationType(), 10);
                    this.appendProperty(res, "q", aa.getQty(), 6);
                }
            }
            res.append('\n');
        }
        return res.toString();
    }

    public String dumpWorkplace(String wpName) {
        Workplace wp = this.configuration.getWorkplace(wpName);
        if (wp == null) {
            return "Invalid workplace name.";
        }
        return this.dumpWorkplaceSchedule(this.plan.getWorkplaceSchedule(wp));
    }

    public String dumpPlan() {
        StringBuilder sb = new StringBuilder();
        for (Workplace wp : this.configuration.getWorkplaces()) {
            sb.append(this.dumpWorkplace(wp.getName()));
            sb.append('\n');
        }
        return sb.toString();
    }

    private String dumpRebuildTypes() {
        StringBuilder sb = new StringBuilder();
        for (Workplace wp : this.configuration.getWorkplaces()) {
            sb.append("Workplace ");
            sb.append(wp.getName());
            sb.append('\n');
            for (RebuildType rebuildType : wp.getRebuildTypes()) {
                sb.append(rebuildType.getName());
                this.appendProperty(sb, "time", rebuildType.getTime(), 8);
                sb.append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public String dumpStores() {
        StringBuilder sb = new StringBuilder();
        sb.append("Store:\n");
        for (StoreType st : StoreType.values()) {
            sb.append(' ');
            sb.append(st.toString());
            sb.append(":\n");
            for (StoreActivity sa : this.plan.getStoreSchedule(st).activities()) {
                sb.append("    ");
                sb.append(sa);
                sb.append('\n');
            }
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public String dumpStores(String material) {
        StringBuilder sb = new StringBuilder();
        Material m3 = this.configuration.getMatprod(material);
        if (m3 != null) {
            sb.append("Store:\n");
            for (StoreType st : StoreType.values()) {
                sb.append(' ');
                sb.append(st.toString());
                sb.append(":\n");
                StoreSchedule ss = this.plan.getStoreSchedule(st);
                if (ss.getMaterials().contains(m3)) {
                    for (StoreActivity sa : ss.getActivities(m3)) {
                        sb.append("    ");
                        sb.append(sa);
                        sb.append('\n');
                    }
                } else {
                    sb.append("    (Material not available in this store)");
                }
                sb.append('\n');
            }
            sb.append('\n');
        } else {
            sb.append("Unknown material ");
            sb.append(material);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String dumpPlan(Plan plan) {
        return new PlanDumper(plan).dumpPlan();
    }

    public static String dumpWorkplace(Plan plan, String wpName) {
        return new PlanDumper(plan).dumpWorkplace(wpName);
    }

    public static String dumpWorkplace(WorkplaceSchedule wps) {
        return new PlanDumper().dumpWorkplaceSchedule(wps);
    }

    public static String dumpStores(Plan plan) {
        return new PlanDumper(plan).dumpStores();
    }

    public static String dumpStores(Plan plan, String material) {
        return new PlanDumper(plan).dumpStores(material);
    }

    public static String dumpRebuildTypes(Plan plan) {
        return new PlanDumper(plan).dumpRebuildTypes();
    }
}

